/**
 * 
 */
package gov.va.genisis2.exceptions;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class Genisis2ExceptionControllerAdvice {
	/** The LOGGER. */
	private static final Logger LOGGER = LoggerFactory.getLogger(Genisis2ExceptionControllerAdvice.class);

	@ExceptionHandler(Exception.class)
	public ResponseEntity<ErrorResponse> exceptionHandler(Exception ex) {
		LOGGER.error("Exception occured. Type: " + ex.getClass().getSimpleName() + " Reason: " + ex.getMessage(), ex);
		ErrorResponse error = new ErrorResponse();
		error.setErrorCode(HttpStatus.INTERNAL_SERVER_ERROR.value());
		error.setMessage(ErrorEnum.INTERNAL_SYS_ERROR.getErrorMessage());
		return new ResponseEntity<>(error, HttpStatus.OK);
	}
}
